# 画面設計書 28-Wasm Test Runner

## 概要

本ドキュメントは、WebAssembly テストランナー画面（index.html）の画面設計書です。.NET WebAssembly 環境でコンパイルされたテストアセンブリを実行するための汎用テストランナーとして実装されています。

### 本画面の処理概要

この画面は、.NET WebAssembly 環境でビルドされたテストアセンブリを実行するための汎用テストランナーページです。WasmAppBuilder タスクによってビルドされた WebAssembly アプリケーションのテスト実行基盤として機能します。

**業務上の目的・背景**：本画面は .NET Runtime のテストインフラストラクチャの一部として、WebAssembly 環境でのテスト自動化を実現するために存在します。CI/CD パイプラインや開発者のローカル環境で、WebAssembly にコンパイルされた .NET テストを実行し、結果を収集するための標準的なエントリーポイントを提供します。

**画面へのアクセス方法**：WasmAppBuilder によってビルドされた WebAssembly アプリケーションの出力ディレクトリ（AppDir）にある index.html にブラウザでアクセスすることで本画面が表示されます。

**主要な操作・処理内容**：
1. ページ読み込み時に test-main.js を読み込み
2. test-main.js が .NET WebAssembly ランタイムを初期化
3. テストアセンブリを読み込み、テストを実行
4. テスト結果をコンソールに出力
5. テスト完了を示すマーカーを DOM に追加

**画面遷移**：本画面は単独で動作するテストランナーであり、他の画面への遷移機能はありません。

**権限による表示制御**：本画面は認証・認可による表示制御を実装していません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyテストの汎用ランナー実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyテストアプリケーションのビルドと実行をサポート |
| 40 | WasmAppBuilder | 補助機能 | テスト用WebAssemblyアプリケーションのビルドサポート |

## 画面種別

テストインフラ / テストランナー

## URL/ルーティング

- **URL**: `/index.html`（静的 HTML ファイル）

## 入出力項目

本画面の入出力は test-main.js およびテスト対象アセンブリに依存します。

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| TestAssemblyFileName | 入力 | string | はい | テスト対象アセンブリのファイル名（ビルド時設定） |
| exit_code | 出力 | int | - | テスト結果の終了コード |

## 表示項目

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|--------------|------|
| （なし） | - | - | 視覚的な UI 要素なし |

## イベント仕様

### 1-ページ読み込み時処理

**トリガー**: ページの読み込み完了時（test-main.js の実行）

**処理フロー**:
1. `test-main.js` モジュールが読み込まれる
2. .NET WebAssembly ランタイムを初期化
3. `WasmMainAssemblyFileName` で指定されたテストアセンブリを読み込み
4. テストを実行
5. 結果に応じた終了コードをコンソールに出力
6. テスト完了を示す DOM 要素を追加

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースとの連携を行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG-001 | ログ出力 | テスト実行ログ | テスト実行中 |
| MSG-002 | ログ出力 | "WASM EXIT {code}" | テスト完了時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| JavaScript Error | .NET ランタイム初期化失敗 | エラーをコンソールに出力 |
| テスト失敗 | 個別テストの失敗 | 失敗件数をカウントし終了コードに反映 |

## 備考

- 本画面は `.NET Runtime` リポジトリのテストインフラストラクチャの一部です。
- WasmTestRunner.proj によってビルド設定が管理されています。
- `test-main.js` は `$(CORE_ROOT)\runtime-test\test-main.js` から参照されます。
- 本画面は最小限の HTML 構造のみを持ち、すべてのロジックは JavaScript で実装されています。
- テスト結果は `WASM EXIT {code}` 形式でコンソールに出力され、テスト自動化ツールがこの出力を検出します。
- V8 エンジンでの実行用スクリプト生成（`WasmGenerateRunV8Script`）もサポートしています。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストランナーのビルド設定を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WasmTestRunner.proj | `src/tests/Common/wasm-test-runner/WasmTestRunner.proj` | MSBuild プロジェクト設定（1-50行目） |

**読解のコツ**: WasmTestRunner.proj は MSBuild のプロジェクトファイルであり、WebAssembly テストアプリケーションのビルド設定を定義しています。`WasmMainAssemblyFileName`、`WasmAppDir`、`WasmMainJSPath` などの重要なプロパティが設定されています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/tests/Common/wasm-test-runner/index.html` | 最小限の HTML 構造（1行） |

**主要処理フロー**:
1. **index.html**: `<script type='module' src='test-main.js'>` で test-main.js を読み込み
2. **WasmTestRunner.proj 29行目**: `WasmMainJSPath` で使用する JavaScript ファイルを指定

#### Step 3: ビルド設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WasmTestRunner.proj | `src/tests/Common/wasm-test-runner/WasmTestRunner.proj` | ビルドターゲットと設定プロパティ |

**主要処理フロー**:
- **6行目**: `IntermediateOutputPath` の設定
- **8行目**: `WasmApp.InTree.props` のインポート
- **14-15行目**: ランタイムパックディレクトリの設定
- **19行目**: `WasmAppBuilderTasksAssemblyPath` で WasmAppBuilder を参照
- **25-33行目**: `BuildApp` ターゲットでビルド設定を定義
- **36-42行目**: `WasmAssembliesToBundle` でバンドルするアセンブリを指定

### プログラム呼び出し階層図

```
WasmTestRunner.proj (MSBuild)
    │
    ├─ WasmApp.InTree.props
    │
    ├─ BuildApp ターゲット
    │      │
    │      ├─ WasmMainAssemblyFileName = $(TestAssemblyFileName)
    │      │
    │      ├─ WasmAppDir = $(AppDir)
    │      │
    │      └─ WasmMainJSPath = $(CORE_ROOT)\runtime-test\test-main.js
    │
    └─ WasmApp.InTree.targets
           │
           └─ WasmBuildApp ターゲット
                  │
                  └─ 出力: AppDir/
                         │
                         ├─ index.html
                         │
                         ├─ test-main.js
                         │
                         └─ _framework/
                                │
                                ├─ dotnet.js
                                │
                                └─ *.dll (テストアセンブリ)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

テストアセンブリ
    │
    └─ WasmAssembliesToBundle ──▶ WasmAppBuilder
                                       │
                                       ▼
                                 WebAssembly アプリ生成
                                       │
                                       ▼
index.html ─────────────────────▶ test-main.js 読み込み
                                       │
                                       ▼
                                 dotnet.js 初期化
                                       │
                                       ▼
                                 テストアセンブリ読み込み
                                       │
                                       ▼
                                 テスト実行 ─────────▶ コンソール出力
                                                        "WASM EXIT {code}"
                                                        │
                                                        ▼
                                                   tests_done 要素追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/tests/Common/wasm-test-runner/index.html` | テンプレート | テストランナーの HTML |
| WasmTestRunner.proj | `src/tests/Common/wasm-test-runner/WasmTestRunner.proj` | 設定 | MSBuild プロジェクト設定 |
| WasmApp.InTree.props | `$(CORE_ROOT)\build\WasmApp.InTree.props` | 設定 | WebAssembly アプリビルドプロパティ |
| WasmApp.InTree.targets | `$(CORE_ROOT)\build\WasmApp.InTree.targets` | 設定 | WebAssembly アプリビルドターゲット |
| WasmAppBuilder.dll | `$(CORE_ROOT)\WasmAppBuilder\WasmAppBuilder.dll` | ツール | WebAssembly アプリビルダー |
| MonoAOTCompiler.dll | `$(CORE_ROOT)\MonoAOTCompiler\MonoAOTCompiler.dll` | ツール | Mono AOT コンパイラ |
| MonoTargetsTasks.dll | `$(CORE_ROOT)\MonoTargetsTasks\MonoTargetsTasks.dll` | ツール | Mono ターゲットタスク |
